#!/bin/sh
# Set Defaults
REGION='us-east-1'
TOPIC='secure_iot_device_analytics'
#TOPIC='iot/topic'
PROFILE='default'
ITERATIONS=300
WAIT=1
unset AWS_CA_BUNDLE
#type aws

aws_version=`aws --version|awk '{print $1}'|awk -F'/' '{print $2}' | awk -F'.' '{print $1}'`
if [[ $aws_version -gt 1 ]]; then
  extra_args=" --cli-binary-format raw-in-base64-out "
else
  extra_args=" "
fi

cloud_shell_env=`echo $AWS_EXECUTION_ENV|grep CloudShell`
if [ -z "$cloud_shell_env" ]; then
        profile_arg=" --profile $PROFILE"
else
     profile_arg=" "
fi

#echo $aws_version $extra_args $profile_arg

# Get command line parameters
while [ "$1" != "" ]; do
  case $1 in
    -r | --region )
    shift
    REGION=$1
    ;;

    -t | --topic )
    shift
    TOPIC=$1
    ;;

    -p | --profile )
    shift
    PROFILE=$1
    ;;

    -i | --iterations )
    shift
    ITERATIONS=$1
    ;;

    -w | --wait )
    shift
    WAIT=$1
    ;;
  esac
  shift
done


for (( i = 1; i <= $ITERATIONS; i++)) {

  PID="P0"$((1 + $RANDOM % 5))
  DEVICE=$i
  BMI=$(( $RANDOM % 40 ))
  HDL=$(( 15 + $RANDOM % 20 ))
  GLUCOSE=$(( 50 + $RANDOM % 40 ))
  SYSTOLE=$(( 100 + $RANDOM % 40 ))
  DIASTOLE=$(( 100 + $RANDOM % 40 ))
  TEMP=$(( 95 + $RANDOM % 20 ))
  DATETIME=$(($(date +%s) / 60 / 60 / 24))

#

 # 3% chance of throwing an anomalous temperature reading
  if [ $(($RANDOM % 100)) -gt 97 ]
  then
    echo "TEMPERATURE OUT OF RANGE"
    TEMP=$(($TEMP*6))
  fi

  echo "Publishing message $i/$ITERATIONS to IoT topic $TOPIC:"
  echo "device: $DEVICE"

  aws iot-data publish $extra_args --topic "$TOPIC" --payload "{\"pid\": \"$PID\",\"device_id\": \"$DEVICE\",\"BMI\": $BMI,\"HDL\": $HDL,\"glucose_level\": $GLUCOSE,\"systole\": $SYSTOLE,\"diastole\": $DIASTOLE,\"date_time\": $DATETIME}" $profile_arg --region "$REGION"
  echo "{\"pid\": \"$PID\",\"device_id\": \"$DEVICE\",\"BMI\": $BMI,\"HDL\": $HDL,\"glucose_level\": $GLUCOSE,\"systole\": $SYSTOLE,\"diastole\": $DIASTOLE,\"date_time\": $DATETIME}"

  #sleep $WAIT

}
